include <gridfinity-rebuilt-openscad-main/gridfinity-rebuilt-lite.scad>
include <BOSL2/std.scad>

/* [Setup Parameters] */
$fa = 8;
$fs = 0.25;

/* [Shitfinity] */
shitfinity_top = false;
shitfinity_bottom_padding = 10;
shitfinity_top_padding = 10;
shitfinity_inner_padding_thickness = 1;
shitfinity_inner_padding = 4.5;

/* [General Settings] */
// number of bases along x-axis
gridx = 1;
// number of bases along y-axis
gridy = 2;
// bin height. See bin height information and "gridz_define" below.

/* [Toggles] */
// snap gridz height to nearest 7mm increment
enable_zsnap = false;
// how should the top lip act
style_lip = 0; //[0: Regular lip, 1:remove lip subtractively, 2: remove lip and retain height]

/* [Other] */
// determine what the variable "gridz" applies to based on your use case
gridz_define = 0; // [0:gridz is the height of bins in units of 7mm increments - Zack's method,1:gridz is the internal height in millimeters, 2:gridz is the overall external height of the bin in millimeters]
// the type of tabs
style_tab = 5; //[0:Full,1:Auto,2:Left,3:Center,4:Right,5:None]

/* [Base] */
style_hole = 0; // [0:no holes, 1:magnet holes only, 2: magnet and screw holes - no printable slit, 3: magnet and screw holes - printable slit]
// only cut magnet/screw holes at the corners of the bin to save uneccesary print time
only_corners = false;
// number of divisions per 1 unit of base along the X axis. (default 1, only use integers. 0 means automatically guess the right division)
div_base_x = 0;
// number of divisions per 1 unit of base along the Y axis. (default 1, only use integers. 0 means automatically guess the right division)
div_base_y = 0;
// thickness of bottom layer
bottom_layer = 1;

// Implementation
divx = 1;
divy = 1;

if (!shitfinity_top){
union(){
difference(){
gridfinityLite(gridx, gridy, 6, gridz_define, style_lip, enable_zsnap, l_grid, div_base_x, div_base_y, style_hole, only_corners) {
    cutEqual(n_divx = divx, n_divy = divy, style_tab = style_tab, scoop_weight = 0);
}
translate ([0,0,shitfinity_bottom_padding+30]) cuboid([42*gridx,42*gridy,60]);
}
#difference(){
cnst=3;
translate ([0,0,shitfinity_bottom_padding/2+cnst/2+bottom_layer/2]) cuboid([42*gridx-shitfinity_inner_padding,42*gridy-shitfinity_inner_padding,shitfinity_bottom_padding-cnst-bottom_layer],rounding=r_f2,edges=[FRONT+LEFT,FRONT+RIGHT,BACK+LEFT,BACK+RIGHT]);
translate ([0,0,shitfinity_bottom_padding/2+cnst/2+bottom_layer/2]) cuboid([42*gridx-shitfinity_inner_padding_thickness-shitfinity_inner_padding,42*gridy-shitfinity_inner_padding_thickness-shitfinity_inner_padding,shitfinity_bottom_padding-cnst-bottom_layer],rounding=r_f2-shitfinity_inner_padding_thickness,edges=[FRONT+LEFT,FRONT+RIGHT,BACK+LEFT,BACK+RIGHT]);
}
}
} else {
union(){
difference(){
gridfinityLite(gridx, gridy, 6, gridz_define, style_lip, enable_zsnap, l_grid, div_base_x, div_base_y, style_hole, only_corners) {
    cutEqual(n_divx = divx, n_divy = divy, style_tab = style_tab, scoop_weight = 0);
}
translate ([0,0,(3.8+6*7-shitfinity_top_padding)/2]) cuboid([42*gridx,42*gridy,3.8+6*7-shitfinity_top_padding]);
}
#translate([0,0,(3.8+6*7-shitfinity_top_padding)]) difference(){
cnst=4;
translate ([0,0,shitfinity_top_padding/2-cnst/2]) cuboid([42*gridx-shitfinity_inner_padding,42*gridy-shitfinity_inner_padding,shitfinity_top_padding-cnst],rounding=r_f2,edges=[FRONT+LEFT,FRONT+RIGHT,BACK+LEFT,BACK+RIGHT]);
translate ([0,0,shitfinity_top_padding/2-cnst/2-1]) cuboid([42*gridx-shitfinity_inner_padding_thickness-shitfinity_inner_padding,42*gridy-shitfinity_inner_padding_thickness-shitfinity_inner_padding,shitfinity_top_padding-cnst+2],rounding=r_f2-shitfinity_inner_padding_thickness,edges=[FRONT+LEFT,FRONT+RIGHT,BACK+LEFT,BACK+RIGHT]);
}
}
}